<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<title><?php echo e(get_option('brand_name', 'Casual Fitness')); ?></title>

	<link rel="icon" href="<?php echo e(logo_url('favicon')); ?>">
	
	<!-- GOOGLE FONT: SOURCE SANS PRO -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

	<!-- IONICONS -->
	<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">

	<!-- FONT AWESOME ICONS -->
	<link href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- ICHECK BOOTSTRAP -->
	<link href="<?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- Theme style -->
	<link href="<?php echo e(asset('assets/css/adminlte.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- ALL GENERAL STYLES USED THROUGH OUT THE APPLICATION -->
	<link href="<?php echo e(asset('assets/css/general.css')); ?>" rel="stylesheet" type="text/css" />
</head>

<body class="hold-transition text-sm layout-fixed">
	<?php echo $__env->yieldContent('content'); ?>

	<!-- JQUERY -->
	<script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>

	<!-- BOOTSTRAP -->
	<script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

	<!-- ADMINLTE -->
	<script src="<?php echo e(asset('assets/js/adminlte.js')); ?>"></script>

	<!-- OPTIONAL SCRIPTS -->
	<script src="<?php echo e(asset('plugins/chart.js/Chart.min.js')); ?>"></script>

	<?php echo $__env->yieldContent('js-script'); ?>
</body>

</html><?php /**PATH /var/www/html/resources/views/layouts/invoice.blade.php ENDPATH**/ ?>